@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the properties for manual resolution.
 * @property targetId Gets or sets the target resource ARM ID of the dependent resource if the resource type is Manual.
 */
public data class ManualResolutionPropertiesResponse(
    public val targetId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ManualResolutionPropertiesResponse): ManualResolutionPropertiesResponse = ManualResolutionPropertiesResponse(
            targetId = javaType.targetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
