@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * MigrateAgent model properties.
 * @property authenticationIdentity Identity model.
 * @property correlationId Gets or sets the MigrateAgent correlation Id.
 * @property customProperties MigrateAgent model custom properties.
 * @property healthErrors Gets or sets the list of health errors.
 * @property isResponsive Gets or sets a value indicating whether MigrateAgent is responsive.
 * @property lastHeartbeat Gets or sets the time when last heartbeat was sent by the MigrateAgent.
 * @property machineId Gets or sets the machine Id where MigrateAgent is running.
 * @property machineName Gets or sets the machine name where MigrateAgent is running.
 * @property provisioningState Gets or sets the provisioning state of the MigrateAgent.
 * @property versionNumber Gets or sets the MigrateAgent version.
 */
public data class MigrateAgentModelPropertiesResponse(
    public val authenticationIdentity: IdentityModelResponse? = null,
    public val correlationId: String,
    public val customProperties: VMwareMigrateAgentModelCustomPropertiesResponse? = null,
    public val healthErrors: List<HealthErrorModelResponse>,
    public val isResponsive: Boolean,
    public val lastHeartbeat: String,
    public val machineId: String? = null,
    public val machineName: String? = null,
    public val provisioningState: String,
    public val versionNumber: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.MigrateAgentModelPropertiesResponse): MigrateAgentModelPropertiesResponse = MigrateAgentModelPropertiesResponse(
            authenticationIdentity = javaType.authenticationIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.IdentityModelResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            correlationId = javaType.correlationId(),
            customProperties = javaType.customProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.VMwareMigrateAgentModelCustomPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.HealthErrorModelResponse.Companion.toKotlin(args0)
                })
            }),
            isResponsive = javaType.isResponsive(),
            lastHeartbeat = javaType.lastHeartbeat(),
            machineId = javaType.machineId().map({ args0 -> args0 }).orElse(null),
            machineName = javaType.machineName().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            versionNumber = javaType.versionNumber(),
        )
    }
}
