@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the dependency override of the move resource.
 * @property id Gets or sets the ARM ID of the dependent resource.
 * @property targetId Gets or sets the resource ARM id of either the MoveResource or the resource ARM ID of
 * the dependent resource.
 */
public data class MoveResourceDependencyOverrideResponse(
    public val id: String? = null,
    public val targetId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.MoveResourceDependencyOverrideResponse): MoveResourceDependencyOverrideResponse = MoveResourceDependencyOverrideResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            targetId = javaType.targetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
