@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Defines the network interface resource settings.
 * @property enableAcceleratedNetworking Gets or sets a value indicating whether accelerated networking is enabled.
 * @property ipConfigurations Gets or sets the IP configurations of the NIC.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Network/networkInterfaces'.
 * @property tags Gets or sets the Resource tags.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 */
public data class NetworkInterfaceResourceSettingsResponse(
    public val enableAcceleratedNetworking: Boolean? = null,
    public val ipConfigurations: List<NicIpConfigurationResourceSettingsResponse>? = null,
    public val resourceType: String,
    public val tags: Map<String, String>? = null,
    public val targetResourceGroupName: String? = null,
    public val targetResourceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.NetworkInterfaceResourceSettingsResponse): NetworkInterfaceResourceSettingsResponse = NetworkInterfaceResourceSettingsResponse(
            enableAcceleratedNetworking = javaType.enableAcceleratedNetworking().map({ args0 ->
                args0
            }).orElse(null),
            ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.NicIpConfigurationResourceSettingsResponse.Companion.toKotlin(args0)
                })
            }),
            resourceType = javaType.resourceType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetResourceGroupName = javaType.targetResourceGroupName().map({ args0 -> args0 }).orElse(null),
            targetResourceName = javaType.targetResourceName(),
        )
    }
}
