@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * Network settings.
 * @property hardwareSoftwareCostPercentage Network hardware and software cost percentage.
 * @property maintenanceCostPercentage Network maintenance cost percentage.
 */
public data class NetworkSettingsResponse(
    public val hardwareSoftwareCostPercentage: Double,
    public val maintenanceCostPercentage: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.NetworkSettingsResponse): NetworkSettingsResponse = NetworkSettingsResponse(
            hardwareSoftwareCostPercentage = javaType.hardwareSoftwareCostPercentage(),
            maintenanceCostPercentage = javaType.maintenanceCostPercentage(),
        )
    }
}
