@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Security Rule data model for Network Security Groups.
 * @property access Gets or sets whether network traffic is allowed or denied.
 * Possible values are “Allow” and “Deny”.
 * @property description Gets or sets a description for this rule. Restricted to 140 chars.
 * @property destinationAddressPrefix Gets or sets destination address prefix. CIDR or source IP range.
 *  A “*” can also be used to match all source IPs. Default tags such
 * as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be used.
 * @property destinationPortRange Gets or sets Destination Port or Range. Integer or range between
 * 0 and 65535. A “*” can also be used to match all ports.
 * @property direction Gets or sets the direction of the rule.InBound or Outbound. The
 * direction specifies if rule will be evaluated on incoming or outgoing traffic.
 * @property name Gets or sets the Security rule name.
 * @property priority Gets or sets the priority of the rule. The value can be between
 * 100 and 4096. The priority number must be unique for each rule in the collection.
 * The lower the priority number, the higher the priority of the rule.
 * @property protocol Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*).
 * @property sourceAddressPrefix Gets or sets source address prefix. CIDR or source IP range. A
 * “*” can also be used to match all source IPs.  Default tags such as ‘VirtualNetwork’,
 * ‘AzureLoadBalancer’ and ‘Internet’ can also be used. If this is an ingress
 * rule, specifies where network traffic originates from.
 * @property sourcePortRange Gets or sets Source Port or Range. Integer or range between 0 and
 * 65535. A “*” can also be used to match all ports.
 */
public data class NsgSecurityRuleResponse(
    public val access: String? = null,
    public val description: String? = null,
    public val destinationAddressPrefix: String? = null,
    public val destinationPortRange: String? = null,
    public val direction: String? = null,
    public val name: String? = null,
    public val priority: Int? = null,
    public val protocol: String? = null,
    public val sourceAddressPrefix: String? = null,
    public val sourcePortRange: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.NsgSecurityRuleResponse): NsgSecurityRuleResponse = NsgSecurityRuleResponse(
            access = javaType.access().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationAddressPrefix = javaType.destinationAddressPrefix().map({ args0 -> args0 }).orElse(null),
            destinationPortRange = javaType.destinationPortRange().map({ args0 -> args0 }).orElse(null),
            direction = javaType.direction().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            sourceAddressPrefix = javaType.sourceAddressPrefix().map({ args0 -> args0 }).orElse(null),
            sourcePortRange = javaType.sourcePortRange().map({ args0 -> args0 }).orElse(null),
        )
    }
}
