@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property os
 * @property osArchitecture
 * @property osName
 * @property osVersion
 */
public data class OperatingSystemDetailsResponse(
    public val os: String? = null,
    public val osArchitecture: String? = null,
    public val osName: String? = null,
    public val osVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.OperatingSystemDetailsResponse): OperatingSystemDetailsResponse = OperatingSystemDetailsResponse(
            os = javaType.os().map({ args0 -> args0 }).orElse(null),
            osArchitecture = javaType.osArchitecture().map({ args0 -> args0 }).orElse(null),
            osName = javaType.osName().map({ args0 -> args0 }).orElse(null),
            osVersion = javaType.osVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
