@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * Other Management Costs Settings.
 * @property dataProtectionCostPerServerPerYear Data Protection Cost Per Server Per Year.
 * @property monitoringCostPerServerPerYear Monitoring Cost Per Server Per Year.
 * @property patchingCostPerServerPerYear Patching Cost Per Server Per Year.
 */
public data class OtherManagementCostsSettingsResponse(
    public val dataProtectionCostPerServerPerYear: Double,
    public val monitoringCostPerServerPerYear: Double,
    public val patchingCostPerServerPerYear: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.OtherManagementCostsSettingsResponse): OtherManagementCostsSettingsResponse = OtherManagementCostsSettingsResponse(
            dataProtectionCostPerServerPerYear = javaType.dataProtectionCostPerServerPerYear(),
            monitoringCostPerServerPerYear = javaType.monitoringCostPerServerPerYear(),
            patchingCostPerServerPerYear = javaType.patchingCostPerServerPerYear(),
        )
    }
}
