@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Data model of Performance Data Settings.
 * @property percentile Gets percentile utilization for performance data.
 * @property perfDataEndTime Gets or sets perf data end time.
 * @property perfDataStartTime Gets or sets perf data start time.
 * @property timeRange Gets perf data time range.
 */
public data class PerfDataSettingsResponse(
    public val percentile: String,
    public val perfDataEndTime: String? = null,
    public val perfDataStartTime: String? = null,
    public val timeRange: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.PerfDataSettingsResponse): PerfDataSettingsResponse = PerfDataSettingsResponse(
            percentile = javaType.percentile(),
            perfDataEndTime = javaType.perfDataEndTime().map({ args0 -> args0 }).orElse(null),
            perfDataStartTime = javaType.perfDataStartTime().map({ args0 -> args0 }).orElse(null),
            timeRange = javaType.timeRange(),
        )
    }
}
