@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Private endpoint connection properties.
 * @property privateEndpoint ARM id for the private endpoint resource corresponding to the connection.
 * @property privateLinkServiceConnectionState State of the private endpoint connection.
 * @property provisioningState Indicates whether there is an ongoing operation on the private endpoint.
 */
public data class PrivateEndpointConnectionPropertiesResponse(
    public val privateEndpoint: ResourceIdResponse,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.PrivateEndpointConnectionPropertiesResponse): PrivateEndpointConnectionPropertiesResponse = PrivateEndpointConnectionPropertiesResponse(
            privateEndpoint = javaType.privateEndpoint().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
            }),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
