@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of a private endpoint connection proxy.
 * @property remotePrivateEndpoint Defines Private endpoint additional details.
 * @property status
 */
public data class PrivateEndpointConnectionProxyPropertiesResponse(
    public val remotePrivateEndpoint: PrivateEndpointDetailsResponse,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.PrivateEndpointConnectionProxyPropertiesResponse): PrivateEndpointConnectionProxyPropertiesResponse =
            PrivateEndpointConnectionProxyPropertiesResponse(
                remotePrivateEndpoint = javaType.remotePrivateEndpoint().let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.PrivateEndpointDetailsResponse.Companion.toKotlin(args0)
                }),
                status = javaType.status(),
            )
    }
}
