@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines Private endpoint additional details.
 * @property connectionDetails
 * @property id
 * @property manualPrivateLinkServiceConnections
 * @property privateLinkServiceConnections
 * @property privateLinkServiceProxies
 */
public data class PrivateEndpointDetailsResponse(
    public val connectionDetails: List<IpConfigurationResponse>? = null,
    public val id: String? = null,
    public val manualPrivateLinkServiceConnections: List<PrivateLinkServiceConnectionResponse>? =
        null,
    public val privateLinkServiceConnections: List<PrivateLinkServiceConnectionResponse>? = null,
    public val privateLinkServiceProxies: List<PrivateLinkServiceProxyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.PrivateEndpointDetailsResponse): PrivateEndpointDetailsResponse = PrivateEndpointDetailsResponse(
            connectionDetails = javaType.connectionDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.IpConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            manualPrivateLinkServiceConnections = javaType.manualPrivateLinkServiceConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.PrivateLinkServiceConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            privateLinkServiceConnections = javaType.privateLinkServiceConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.PrivateLinkServiceConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            privateLinkServiceProxies = javaType.privateLinkServiceProxies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.PrivateLinkServiceProxyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
