@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines Private link service connection.
 * @property groupIds
 * @property id
 * @property name
 * @property requestMessage
 */
public data class PrivateLinkServiceConnectionResponse(
    public val groupIds: List<String>? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val requestMessage: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.PrivateLinkServiceConnectionResponse): PrivateLinkServiceConnectionResponse = PrivateLinkServiceConnectionResponse(
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            requestMessage = javaType.requestMessage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
