@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines Private link service proxy.
 * @property groupConnectivityInformation
 * @property id
 * @property remotePrivateEndpointConnection Defines resource ID of a private endpoint connection.
 * @property remotePrivateLinkServiceConnectionState Private endpoint connection state.
 */
public data class PrivateLinkServiceProxyResponse(
    public val groupConnectivityInformation: List<GroupConnectivityInformationResponse>? = null,
    public val id: String? = null,
    public val remotePrivateEndpointConnection: ResourceIdResponse? = null,
    public val remotePrivateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.PrivateLinkServiceProxyResponse): PrivateLinkServiceProxyResponse = PrivateLinkServiceProxyResponse(
            groupConnectivityInformation = javaType.groupConnectivityInformation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.GroupConnectivityInformationResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            remotePrivateEndpointConnection = javaType.remotePrivateEndpointConnection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            remotePrivateLinkServiceConnectionState = javaType.remotePrivateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
