@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property principalId
 * @property tenantId
 * @property type
 * @property userAssignedIdentities
 */
public data class ResourceIdentityResponse(
    public val principalId: String? = null,
    public val tenantId: String? = null,
    public val type: String? = null,
    public val userAssignedIdentities: Map<String, UserAssignedIdentityResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ResourceIdentityResponse): ResourceIdentityResponse = ResourceIdentityResponse(
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.migrate.kotlin.outputs.UserAssignedIdentityResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
