@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resource Requirements.
 * @property cpu Gets or sets the Cpu requirement.
 * @property memory Gets or sets the Memory requirement.
 */
public data class ResourceRequirementsResponse(
    public val cpu: String? = null,
    public val memory: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ResourceRequirementsResponse): ResourceRequirementsResponse = ResourceRequirementsResponse(
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
