@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Class representing the servers project summary.
 * @property assessedCount Gets or sets the count of entities assessed.
 * @property discoveredCount Gets or sets the count of entities discovered.
 * @property extendedSummary Gets or sets the extended summary.
 * @property instanceType Gets the Instance type.
 * Expected value is 'Servers'.
 * @property lastSummaryRefreshedTime Gets or sets the time when summary was last refreshed.
 * @property migratedCount Gets or sets the count of entities migrated.
 * @property refreshSummaryState Gets or sets the state of refresh summary.
 * @property replicatingCount Gets or sets the count of entities being replicated.
 * @property testMigratedCount Gets or sets the count of entities test migrated.
 */
public data class ServersProjectSummaryResponse(
    public val assessedCount: Int? = null,
    public val discoveredCount: Int? = null,
    public val extendedSummary: Map<String, String>? = null,
    public val instanceType: String,
    public val lastSummaryRefreshedTime: String? = null,
    public val migratedCount: Int? = null,
    public val refreshSummaryState: String? = null,
    public val replicatingCount: Int? = null,
    public val testMigratedCount: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ServersProjectSummaryResponse): ServersProjectSummaryResponse = ServersProjectSummaryResponse(
            assessedCount = javaType.assessedCount().map({ args0 -> args0 }).orElse(null),
            discoveredCount = javaType.discoveredCount().map({ args0 -> args0 }).orElse(null),
            extendedSummary = javaType.extendedSummary().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            instanceType = javaType.instanceType(),
            lastSummaryRefreshedTime = javaType.lastSummaryRefreshedTime().map({ args0 -> args0 }).orElse(null),
            migratedCount = javaType.migratedCount().map({ args0 -> args0 }).orElse(null),
            refreshSummaryState = javaType.refreshSummaryState().map({ args0 -> args0 }).orElse(null),
            replicatingCount = javaType.replicatingCount().map({ args0 -> args0 }).orElse(null),
            testMigratedCount = javaType.testMigratedCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
