@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Class for solution properties.
 * @property cleanupState Gets or sets the cleanup state of the solution.
 * @property details Gets or sets the details of the solution.
 * @property goal Gets or sets the goal of the solution.
 * @property purpose Gets or sets the purpose of the solution.
 * @property status Gets or sets the current status of the solution.
 * @property summary Gets or sets the summary of the solution.
 * @property tool Gets or sets the tool being used in the solution.
 */
public data class SolutionPropertiesResponse(
    public val cleanupState: String? = null,
    public val details: SolutionDetailsResponse? = null,
    public val goal: String? = null,
    public val purpose: String? = null,
    public val status: String? = null,
    public val summary: Any? = null,
    public val tool: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.SolutionPropertiesResponse): SolutionPropertiesResponse = SolutionPropertiesResponse(
            cleanupState = javaType.cleanupState().map({ args0 -> args0 }).orElse(null),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.SolutionDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            goal = javaType.goal().map({ args0 -> args0 }).orElse(null),
            purpose = javaType.purpose().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            summary = javaType.summary().map({ args0 -> args0 }).orElse(null),
            tool = javaType.tool().map({ args0 -> args0 }).orElse(null),
        )
    }
}
