@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SQL database assessment settings.
 * @property azureSqlComputeTier Gets or sets the azure SQL compute tier.
 * @property azureSqlDataBaseType Gets or sets the azure PAAS SQL instance type.
 * @property azureSqlPurchaseModel Gets or sets the azure SQL purchase model.
 * @property azureSqlServiceTier Gets or sets the azure SQL service tier.
 */
public data class SqlDbSettingsResponse(
    public val azureSqlComputeTier: String? = null,
    public val azureSqlDataBaseType: String? = null,
    public val azureSqlPurchaseModel: String? = null,
    public val azureSqlServiceTier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.SqlDbSettingsResponse): SqlDbSettingsResponse = SqlDbSettingsResponse(
            azureSqlComputeTier = javaType.azureSqlComputeTier().map({ args0 -> args0 }).orElse(null),
            azureSqlDataBaseType = javaType.azureSqlDataBaseType().map({ args0 -> args0 }).orElse(null),
            azureSqlPurchaseModel = javaType.azureSqlPurchaseModel().map({ args0 -> args0 }).orElse(null),
            azureSqlServiceTier = javaType.azureSqlServiceTier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
