@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Defines the Sql ElasticPool resource settings.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Sql/servers/elasticPools'.
 * @property tags Gets or sets the Resource tags.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 * @property zoneRedundant Defines the zone redundant resource setting.
 */
public data class SqlElasticPoolResourceSettingsResponse(
    public val resourceType: String,
    public val tags: Map<String, String>? = null,
    public val targetResourceGroupName: String? = null,
    public val targetResourceName: String,
    public val zoneRedundant: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.SqlElasticPoolResourceSettingsResponse): SqlElasticPoolResourceSettingsResponse = SqlElasticPoolResourceSettingsResponse(
            resourceType = javaType.resourceType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetResourceGroupName = javaType.targetResourceGroupName().map({ args0 -> args0 }).orElse(null),
            targetResourceName = javaType.targetResourceName(),
            zoneRedundant = javaType.zoneRedundant().map({ args0 -> args0 }).orElse(null),
        )
    }
}
