@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SQL managed instance assessment settings.
 * @property azureSqlInstanceType Gets or sets the azure PAAS SQL instance type.
 * @property azureSqlServiceTier Gets or sets the azure SQL service tier.
 */
public data class SqlMiSettingsResponse(
    public val azureSqlInstanceType: String? = null,
    public val azureSqlServiceTier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.SqlMiSettingsResponse): SqlMiSettingsResponse = SqlMiSettingsResponse(
            azureSqlInstanceType = javaType.azureSqlInstanceType().map({ args0 -> args0 }).orElse(null),
            azureSqlServiceTier = javaType.azureSqlServiceTier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
