@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * SQL Server licensing settings.
 * @property licenseCost Licence cost.
 * @property softwareAssuranceCost Software assurance (SA) cost.
 * @property version SQL Server version.
 */
public data class SqlServerLicensingSettingsResponse(
    public val licenseCost: Double,
    public val softwareAssuranceCost: Double,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.SqlServerLicensingSettingsResponse): SqlServerLicensingSettingsResponse = SqlServerLicensingSettingsResponse(
            licenseCost = javaType.licenseCost(),
            softwareAssuranceCost = javaType.softwareAssuranceCost(),
            version = javaType.version(),
        )
    }
}
