@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * SQL VM assessment settings.
 * @property instanceSeries Gets or sets the Azure VM families (calling instance series to keep it
 * consistent with other targets).
 */
public data class SqlVmSettingsResponse(
    public val instanceSeries: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.SqlVmSettingsResponse): SqlVmSettingsResponse = SqlVmSettingsResponse(
            instanceSeries = javaType.instanceSeries().map({ args0 -> args0 }),
        )
    }
}
