@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * Storage settings.
 * @property costPerGbPerMonth Cost per gigabyte per month.
 * @property maintainanceCostPercentageToAcquisitionCost Maintenance cost percentage.
 */
public data class StorageSettingsResponse(
    public val costPerGbPerMonth: Double,
    public val maintainanceCostPercentageToAcquisitionCost: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.StorageSettingsResponse): StorageSettingsResponse = StorageSettingsResponse(
            costPerGbPerMonth = javaType.costPerGbPerMonth(),
            maintainanceCostPercentageToAcquisitionCost = javaType.maintainanceCostPercentageToAcquisitionCost(),
        )
    }
}
