@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the virtual network subnets resource settings.
 * @property addressPrefix Gets or sets address prefix for the subnet.
 * @property name Gets or sets the Subnet name.
 * @property networkSecurityGroup Defines reference to NSG.
 */
public data class SubnetResourceSettingsResponse(
    public val addressPrefix: String? = null,
    public val name: String? = null,
    public val networkSecurityGroup: NsgReferenceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.SubnetResourceSettingsResponse): SubnetResourceSettingsResponse = SubnetResourceSettingsResponse(
            addressPrefix = javaType.addressPrefix().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            networkSecurityGroup = javaType.networkSecurityGroup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.NsgReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
