@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Storage profile for the directory on the target container.
 * @property azureFileShareProfile Azure file share profile for hydration of application folders not mounted on
 * the container file system.
 * @property hydrationStorageProviderType Gets or sets the storage provider type on the target.
 * Applicable when StorageProjectionType is not ContainerFileSystem.
 * @property persistentVolumeId Gets or sets the target persistent volume id.
 * Applicable when StorageProjectionType is PersistentVolume and on using an
 * existing PersistentVolume.
 * @property storageAccessType Gets or sets the target storage access type.
 * @property storageProjectionType Gets or sets the target projection type.
 * @property targetName Gets or sets the name of the projected volume on the target environment.
 * @property targetSize Gets or sets the storage size on the target.
 * Applicable when StorageProjectionType is PersistentVolume and on creating a new
 * PersistentVolume.
 */
public data class TargetStorageProfileResponse(
    public val azureFileShareProfile: AzureFileShareHydrationProfileResponse? = null,
    public val hydrationStorageProviderType: String? = null,
    public val persistentVolumeId: String? = null,
    public val storageAccessType: String? = null,
    public val storageProjectionType: String? = null,
    public val targetName: String? = null,
    public val targetSize: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.TargetStorageProfileResponse): TargetStorageProfileResponse = TargetStorageProfileResponse(
            azureFileShareProfile = javaType.azureFileShareProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.AzureFileShareHydrationProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hydrationStorageProviderType = javaType.hydrationStorageProviderType().map({ args0 ->
                args0
            }).orElse(null),
            persistentVolumeId = javaType.persistentVolumeId().map({ args0 -> args0 }).orElse(null),
            storageAccessType = javaType.storageAccessType().map({ args0 -> args0 }).orElse(null),
            storageProjectionType = javaType.storageProjectionType().map({ args0 -> args0 }).orElse(null),
            targetName = javaType.targetName().map({ args0 -> args0 }).orElse(null),
            targetSize = javaType.targetSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
