@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * Third Party Management settings.
 * @property licenseCost License Cost.
 * @property supportCost Support Cost.
 */
public data class ThirdPartyManagementSettingsResponse(
    public val licenseCost: Double,
    public val supportCost: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ThirdPartyManagementSettingsResponse): ThirdPartyManagementSettingsResponse = ThirdPartyManagementSettingsResponse(
            licenseCost = javaType.licenseCost(),
            supportCost = javaType.supportCost(),
        )
    }
}
