@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * VMware MigrateAgent model custom properties.
 * @property fabricFriendlyName Gets or sets the friendly name of the,of the MigrateAgent fabric.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'VMwareMigrateAgentModelCustomProperties'.
 * @property vmwareSiteId Gets or sets the master Site Id of the Migrate Agent.
 */
public data class VMwareMigrateAgentModelCustomPropertiesResponse(
    public val fabricFriendlyName: String? = null,
    public val instanceType: String,
    public val vmwareSiteId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.VMwareMigrateAgentModelCustomPropertiesResponse): VMwareMigrateAgentModelCustomPropertiesResponse =
            VMwareMigrateAgentModelCustomPropertiesResponse(
                fabricFriendlyName = javaType.fabricFriendlyName().map({ args0 -> args0 }).orElse(null),
                instanceType = javaType.instanceType(),
                vmwareSiteId = javaType.vmwareSiteId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
