@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Gets or sets the virtual machine resource settings.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Compute/virtualMachines'.
 * @property tags Gets or sets the Resource tags.
 * @property targetAvailabilitySetId Gets or sets the target availability set id for virtual machines not in an availability set at source.
 * @property targetAvailabilityZone Gets or sets the target availability zone.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 * @property targetVmSize Gets or sets the target virtual machine size.
 * @property userManagedIdentities Gets or sets user-managed identities
 */
public data class VirtualMachineResourceSettingsResponse(
    public val resourceType: String,
    public val tags: Map<String, String>? = null,
    public val targetAvailabilitySetId: String? = null,
    public val targetAvailabilityZone: String? = null,
    public val targetResourceGroupName: String? = null,
    public val targetResourceName: String,
    public val targetVmSize: String? = null,
    public val userManagedIdentities: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.VirtualMachineResourceSettingsResponse): VirtualMachineResourceSettingsResponse = VirtualMachineResourceSettingsResponse(
            resourceType = javaType.resourceType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetAvailabilitySetId = javaType.targetAvailabilitySetId().map({ args0 -> args0 }).orElse(null),
            targetAvailabilityZone = javaType.targetAvailabilityZone().map({ args0 -> args0 }).orElse(null),
            targetResourceGroupName = javaType.targetResourceGroupName().map({ args0 -> args0 }).orElse(null),
            targetResourceName = javaType.targetResourceName(),
            targetVmSize = javaType.targetVmSize().map({ args0 -> args0 }).orElse(null),
            userManagedIdentities = javaType.userManagedIdentities().map({ args0 -> args0 }),
        )
    }
}
