@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * Details on the total up-time for the VM.
 * @property daysPerMonth Number of days in a month for VM uptime.
 * @property hoursPerDay Number of hours per day for VM uptime.
 */
public data class VmUptimeResponse(
    public val daysPerMonth: Double? = null,
    public val hoursPerDay: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.VmUptimeResponse): VmUptimeResponse = VmUptimeResponse(
            daysPerMonth = javaType.daysPerMonth().map({ args0 -> args0 }).orElse(null),
            hoursPerDay = javaType.hoursPerDay().map({ args0 -> args0 }).orElse(null),
        )
    }
}
