@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Representation of a vsphere licence.
 * @property basicSupportCost Basic support cost.
 * @property licenseCost Cost of a licence.
 * @property licenseType VSphere licence type.
 * @property productionSupportCost Production support cost.
 */
public data class VsphereLicenseResponse(
    public val basicSupportCost: Double,
    public val licenseCost: Double,
    public val licenseType: String,
    public val productionSupportCost: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.VsphereLicenseResponse): VsphereLicenseResponse = VsphereLicenseResponse(
            basicSupportCost = javaType.basicSupportCost(),
            licenseCost = javaType.licenseCost(),
            licenseType = javaType.licenseType(),
            productionSupportCost = javaType.productionSupportCost(),
        )
    }
}
