@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * WebApplication directory structure.
 * @property id Gets the unique id corresponding to the application directory.
 * @property isEditable Gets or sets a value indicating whether the directory object is editable.
 * True when the directory is added as an optional directory, false when discovery is done
 * manually.
 * @property sourcePaths Gets or sets the paths of the directory on the source machine.
 * @property sourceSize Gets or sets the size of the directory on the source machine.
 * @property storageProfile Storage profile for the directory on the target container.
 */
public data class WebApplicationDirectoryResponse(
    public val id: String,
    public val isEditable: Boolean? = null,
    public val sourcePaths: List<String>? = null,
    public val sourceSize: String? = null,
    public val storageProfile: TargetStorageProfileResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.WebApplicationDirectoryResponse): WebApplicationDirectoryResponse = WebApplicationDirectoryResponse(
            id = javaType.id(),
            isEditable = javaType.isEditable().map({ args0 -> args0 }).orElse(null),
            sourcePaths = javaType.sourcePaths().map({ args0 -> args0 }),
            sourceSize = javaType.sourceSize().map({ args0 -> args0 }).orElse(null),
            storageProfile = javaType.storageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.TargetStorageProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
