@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * Windows Server licensing settings.
 * @property licenseCost Licence Cost.
 * @property licensesPerCore Licenses per core.
 * @property softwareAssuranceCost Software assurance (SA) cost.
 */
public data class WindowsServerLicensingSettingsResponse(
    public val licenseCost: Double,
    public val licensesPerCore: Int,
    public val softwareAssuranceCost: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.WindowsServerLicensingSettingsResponse): WindowsServerLicensingSettingsResponse = WindowsServerLicensingSettingsResponse(
            licenseCost = javaType.licenseCost(),
            licensesPerCore = javaType.licensesPerCore(),
            softwareAssuranceCost = javaType.softwareAssuranceCost(),
        )
    }
}
