@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Workload deployment model properties.
 * @property allowedOperations Gets or sets the allowed scenarios on the workload deployment.
 * @property correlationId Gets or sets the workload deployment correlation Id.
 * @property currentJob
 * @property customProperties Workload deployment model custom properties.
 * @property displayName Gets or sets the display name.
 * @property healthErrors Gets or sets the list of health errors.
 * @property lastSuccessfulMigrateTime Gets or sets the Last successful unplanned migrate time.
 * @property lastSuccessfulTestMigrateTime Gets or sets the Last successful test migrate time.
 * @property migrationStatus Gets or sets the migrate state.
 * @property migrationStatusDescription Gets or sets the migrate state description.
 * @property provisioningState Gets or sets the provisioning state of the workload deployment.
 * @property status Gets or sets the workload deployment status.
 * @property statusDescription Gets or sets the workload deployment status description.
 * @property targetPlatform Gets or sets the deployment target platform.
 * @property testMigrationStatus Gets or sets the test migrate state.
 * @property testMigrationStatusDescription Gets or sets the Test migrate state description.
 * @property workloadInstanceProperties Workload instance model properties.
 */
public data class WorkloadDeploymentModelPropertiesResponse(
    public val allowedOperations: List<String>,
    public val correlationId: String,
    public val currentJob: WorkloadDeploymentModelPropertiesResponseCurrentJob,
    public val customProperties: Either<ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesResponse, IISAKSWorkloadDeploymentModelCustomPropertiesResponse>? =
        null,
    public val displayName: String? = null,
    public val healthErrors: List<HealthErrorModelResponse>,
    public val lastSuccessfulMigrateTime: String,
    public val lastSuccessfulTestMigrateTime: String,
    public val migrationStatus: String,
    public val migrationStatusDescription: String,
    public val provisioningState: String,
    public val status: String,
    public val statusDescription: String,
    public val targetPlatform: String? = null,
    public val testMigrationStatus: String,
    public val testMigrationStatusDescription: String,
    public val workloadInstanceProperties: WorkloadInstanceModelPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.WorkloadDeploymentModelPropertiesResponse): WorkloadDeploymentModelPropertiesResponse = WorkloadDeploymentModelPropertiesResponse(
            allowedOperations = javaType.allowedOperations().map({ args0 -> args0 }),
            correlationId = javaType.correlationId(),
            currentJob = javaType.currentJob().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.WorkloadDeploymentModelPropertiesResponseCurrentJob.Companion.toKotlin(args0)
            }),
            customProperties = javaType.customProperties().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.migrate.kotlin.outputs.ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.migrate.kotlin.outputs.IISAKSWorkloadDeploymentModelCustomPropertiesResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.HealthErrorModelResponse.Companion.toKotlin(args0)
                })
            }),
            lastSuccessfulMigrateTime = javaType.lastSuccessfulMigrateTime(),
            lastSuccessfulTestMigrateTime = javaType.lastSuccessfulTestMigrateTime(),
            migrationStatus = javaType.migrationStatus(),
            migrationStatusDescription = javaType.migrationStatusDescription(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status(),
            statusDescription = javaType.statusDescription(),
            targetPlatform = javaType.targetPlatform().map({ args0 -> args0 }).orElse(null),
            testMigrationStatus = javaType.testMigrationStatus(),
            testMigrationStatusDescription = javaType.testMigrationStatusDescription(),
            workloadInstanceProperties = javaType.workloadInstanceProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.WorkloadInstanceModelPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
