@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property displayName Gets or sets the workflow friendly display name.
 * @property endTime Gets or sets end time of the workflow.
 * @property id Gets or sets workflow Id.
 * @property name Gets or sets workflow name.
 * @property scenarioName Gets or sets workload scenario name.
 * @property startTime Gets or sets start time of the workflow.
 * @property state Gets or sets workflow state.
 */
public data class WorkloadInstanceModelPropertiesResponseCurrentJob(
    public val displayName: String,
    public val endTime: String,
    public val id: String,
    public val name: String,
    public val scenarioName: String,
    public val startTime: String,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.WorkloadInstanceModelPropertiesResponseCurrentJob): WorkloadInstanceModelPropertiesResponseCurrentJob =
            WorkloadInstanceModelPropertiesResponseCurrentJob(
                displayName = javaType.displayName(),
                endTime = javaType.endTime(),
                id = javaType.id(),
                name = javaType.name(),
                scenarioName = javaType.scenarioName(),
                startTime = javaType.startTime(),
                state = javaType.state(),
            )
    }
}
