@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mixedreality.kotlin.inputs

import com.pulumi.azurenative.mixedreality.inputs.GetRemoteRenderingAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Name of an Mixed Reality Account.
 * @property resourceGroupName Name of an Azure resource group.
 */
public data class GetRemoteRenderingAccountPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mixedreality.inputs.GetRemoteRenderingAccountPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mixedreality.inputs.GetRemoteRenderingAccountPlainArgs =
        com.pulumi.azurenative.mixedreality.inputs.GetRemoteRenderingAccountPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRemoteRenderingAccountPlainArgs].
 */
@PulumiTagMarker
public class GetRemoteRenderingAccountPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of an Mixed Reality Account.
     */
    @JvmName("mrdksjfmmwkodyuj")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Name of an Azure resource group.
     */
    @JvmName("xenplwaxfqiwmtpo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRemoteRenderingAccountPlainArgs = GetRemoteRenderingAccountPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
