@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mixedreality.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * RemoteRenderingAccount Response.
 * @property accountDomain Correspond domain name of certain Spatial Anchors Account
 * @property accountId unique id of certain account.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity associated with this account
 * @property kind The kind of account, if supported
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property plan The plan associated with this account
 * @property sku The sku associated with this account
 * @property storageAccountName The name of the storage account associated with this accountId
 * @property systemData System metadata for this account
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetRemoteRenderingAccountResult(
    public val accountDomain: String,
    public val accountId: String,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val kind: SkuResponse? = null,
    public val location: String,
    public val name: String,
    public val plan: IdentityResponse? = null,
    public val sku: SkuResponse? = null,
    public val storageAccountName: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mixedreality.outputs.GetRemoteRenderingAccountResult): GetRemoteRenderingAccountResult = GetRemoteRenderingAccountResult(
            accountDomain = javaType.accountDomain(),
            accountId = javaType.accountId(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mixedreality.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kind = javaType.kind().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mixedreality.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            plan = javaType.plan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mixedreality.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mixedreality.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageAccountName = javaType.storageAccountName().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.mixedreality.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
