@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mixedreality.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property principalId The principal ID of resource identity.
 * @property tenantId The tenant ID of resource.
 * @property type The identity type.
 */
public data class ObjectAnchorsAccountResponseIdentity(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mixedreality.outputs.ObjectAnchorsAccountResponseIdentity): ObjectAnchorsAccountResponseIdentity = ObjectAnchorsAccountResponseIdentity(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
