@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.InterfacePropertiesResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.NaptConfigurationResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.InterfacePropertiesResponse.Companion.toKotlin as interfacePropertiesResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.NaptConfigurationResponse.Companion.toKotlin as naptConfigurationResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AttachedDataNetwork].
 */
@PulumiTagMarker
public class AttachedDataNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AttachedDataNetworkArgs = AttachedDataNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AttachedDataNetworkArgsBuilder.() -> Unit) {
        val builder = AttachedDataNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AttachedDataNetwork {
        val builtJavaResource =
            com.pulumi.azurenative.mobilenetwork.AttachedDataNetwork(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AttachedDataNetwork(builtJavaResource)
    }
}

/**
 * Attached data network resource. Must be created in the same location as its parent packet core data plane.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01, 2024-04-01.
 * ## Example Usage
 * ### Create attached data network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attachedDataNetwork = new AzureNative.MobileNetwork.AttachedDataNetwork("attachedDataNetwork", new()
 *     {
 *         AttachedDataNetworkName = "TestAttachedDataNetwork",
 *         DnsAddresses = new[]
 *         {
 *             "1.1.1.1",
 *         },
 *         Location = "eastus",
 *         NaptConfiguration = new AzureNative.MobileNetwork.Inputs.NaptConfigurationArgs
 *         {
 *             Enabled = AzureNative.MobileNetwork.NaptEnabled.Enabled,
 *             PinholeLimits = 65536,
 *             PinholeTimeouts = new AzureNative.MobileNetwork.Inputs.PinholeTimeoutsArgs
 *             {
 *                 Icmp = 30,
 *                 Tcp = 180,
 *                 Udp = 30,
 *             },
 *             PortRange = new AzureNative.MobileNetwork.Inputs.PortRangeArgs
 *             {
 *                 MaxPort = 49999,
 *                 MinPort = 1024,
 *             },
 *             PortReuseHoldTime = new AzureNative.MobileNetwork.Inputs.PortReuseHoldTimesArgs
 *             {
 *                 Tcp = 120,
 *                 Udp = 60,
 *             },
 *         },
 *         PacketCoreControlPlaneName = "TestPacketCoreCP",
 *         PacketCoreDataPlaneName = "TestPacketCoreDP",
 *         ResourceGroupName = "rg1",
 *         UserEquipmentAddressPoolPrefix = new[]
 *         {
 *             "2.2.0.0/16",
 *         },
 *         UserEquipmentStaticAddressPoolPrefix = new[]
 *         {
 *             "2.4.0.0/16",
 *         },
 *         UserPlaneDataInterface = new AzureNative.MobileNetwork.Inputs.InterfacePropertiesArgs
 *         {
 *             Name = "N6",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewAttachedDataNetwork(ctx, "attachedDataNetwork", &mobilenetwork.AttachedDataNetworkArgs{
 * 			AttachedDataNetworkName: pulumi.String("TestAttachedDataNetwork"),
 * 			DnsAddresses: pulumi.StringArray{
 * 				pulumi.String("1.1.1.1"),
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			NaptConfiguration: &mobilenetwork.NaptConfigurationArgs{
 * 				Enabled:       pulumi.String(mobilenetwork.NaptEnabledEnabled),
 * 				PinholeLimits: pulumi.Int(65536),
 * 				PinholeTimeouts: &mobilenetwork.PinholeTimeoutsArgs{
 * 					Icmp: pulumi.Int(30),
 * 					Tcp:  pulumi.Int(180),
 * 					Udp:  pulumi.Int(30),
 * 				},
 * 				PortRange: &mobilenetwork.PortRangeArgs{
 * 					MaxPort: pulumi.Int(49999),
 * 					MinPort: pulumi.Int(1024),
 * 				},
 * 				PortReuseHoldTime: &mobilenetwork.PortReuseHoldTimesArgs{
 * 					Tcp: pulumi.Int(120),
 * 					Udp: pulumi.Int(60),
 * 				},
 * 			},
 * 			PacketCoreControlPlaneName: pulumi.String("TestPacketCoreCP"),
 * 			PacketCoreDataPlaneName:    pulumi.String("TestPacketCoreDP"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			UserEquipmentAddressPoolPrefix: pulumi.StringArray{
 * 				pulumi.String("2.2.0.0/16"),
 * 			},
 * 			UserEquipmentStaticAddressPoolPrefix: pulumi.StringArray{
 * 				pulumi.String("2.4.0.0/16"),
 * 			},
 * 			UserPlaneDataInterface: &mobilenetwork.InterfacePropertiesArgs{
 * 				Name: pulumi.String("N6"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.AttachedDataNetwork;
 * import com.pulumi.azurenative.mobilenetwork.AttachedDataNetworkArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.NaptConfigurationArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.PinholeTimeoutsArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.PortRangeArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.PortReuseHoldTimesArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.InterfacePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attachedDataNetwork = new AttachedDataNetwork("attachedDataNetwork", AttachedDataNetworkArgs.builder()
 *             .attachedDataNetworkName("TestAttachedDataNetwork")
 *             .dnsAddresses("1.1.1.1")
 *             .location("eastus")
 *             .naptConfiguration(NaptConfigurationArgs.builder()
 *                 .enabled("Enabled")
 *                 .pinholeLimits(65536)
 *                 .pinholeTimeouts(PinholeTimeoutsArgs.builder()
 *                     .icmp(30)
 *                     .tcp(180)
 *                     .udp(30)
 *                     .build())
 *                 .portRange(PortRangeArgs.builder()
 *                     .maxPort(49999)
 *                     .minPort(1024)
 *                     .build())
 *                 .portReuseHoldTime(PortReuseHoldTimesArgs.builder()
 *                     .tcp(120)
 *                     .udp(60)
 *                     .build())
 *                 .build())
 *             .packetCoreControlPlaneName("TestPacketCoreCP")
 *             .packetCoreDataPlaneName("TestPacketCoreDP")
 *             .resourceGroupName("rg1")
 *             .userEquipmentAddressPoolPrefix("2.2.0.0/16")
 *             .userEquipmentStaticAddressPoolPrefix("2.4.0.0/16")
 *             .userPlaneDataInterface(InterfacePropertiesArgs.builder()
 *                 .name("N6")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:AttachedDataNetwork TestAttachedDataNetwork /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCoreDataPlanes/{packetCoreDataPlaneName}/attachedDataNetworks/{attachedDataNetworkName}
 * ```
 */
public class AttachedDataNetwork internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilenetwork.AttachedDataNetwork,
) : KotlinCustomResource(javaResource, AttachedDataNetworkMapper) {
    /**
     * The DNS servers to signal to UEs to use for this attached data network. This configuration is mandatory - if you don't want DNS servers, you must provide an empty array.
     */
    public val dnsAddresses: Output<List<String>>
        get() = javaResource.dnsAddresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The network address and port translation (NAPT) configuration.
     * If this is not specified, the attached data network will use a default NAPT configuration with NAPT enabled.
     */
    public val naptConfiguration: Output<NaptConfigurationResponse>?
        get() = javaResource.naptConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> naptConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The provisioning state of the attached data network resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs.
     * The packet core instance assigns an IP address to a UE when the UE sets up a PDU session.
     *  You must define at least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix. If you define both, they must be of the same size.
     */
    public val userEquipmentAddressPoolPrefix: Output<List<String>>?
        get() = javaResource.userEquipmentAddressPoolPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs.
     * The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource.
     * At least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix must be defined. If both are defined, they must be of the same size.
     */
    public val userEquipmentStaticAddressPoolPrefix: Output<List<String>>?
        get() = javaResource.userEquipmentStaticAddressPoolPrefix().applyValue({ args0 ->
            args0.map({ args0 -> args0.map({ args0 -> args0 }) }).orElse(null)
        })

    /**
     * The user plane interface on the data network. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface.
     */
    public val userPlaneDataInterface: Output<InterfacePropertiesResponse>
        get() = javaResource.userPlaneDataInterface().applyValue({ args0 ->
            args0.let({ args0 ->
                interfacePropertiesResponseToKotlin(args0)
            })
        })
}

public object AttachedDataNetworkMapper : ResourceMapper<AttachedDataNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilenetwork.AttachedDataNetwork::class == javaResource::class

    override fun map(javaResource: Resource): AttachedDataNetwork = AttachedDataNetwork(
        javaResource
            as com.pulumi.azurenative.mobilenetwork.AttachedDataNetwork,
    )
}

/**
 * @see [AttachedDataNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AttachedDataNetwork].
 */
public suspend fun attachedDataNetwork(
    name: String,
    block: suspend AttachedDataNetworkResourceBuilder.() -> Unit,
): AttachedDataNetwork {
    val builder = AttachedDataNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AttachedDataNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun attachedDataNetwork(name: String): AttachedDataNetwork {
    val builder = AttachedDataNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
