@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.DiagnosticsPackageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Diagnostics package resource.
 * Azure REST API version: 2023-06-01.
 * Other available API versions: 2023-09-01, 2024-02-01, 2024-04-01.
 * ## Example Usage
 * ### Create diagnostics package
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diagnosticsPackage = new AzureNative.MobileNetwork.DiagnosticsPackage("diagnosticsPackage", new()
 *     {
 *         DiagnosticsPackageName = "dp1",
 *         PacketCoreControlPlaneName = "TestPacketCoreCP",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewDiagnosticsPackage(ctx, "diagnosticsPackage", &mobilenetwork.DiagnosticsPackageArgs{
 * 			DiagnosticsPackageName:     pulumi.String("dp1"),
 * 			PacketCoreControlPlaneName: pulumi.String("TestPacketCoreCP"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.DiagnosticsPackage;
 * import com.pulumi.azurenative.mobilenetwork.DiagnosticsPackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diagnosticsPackage = new DiagnosticsPackage("diagnosticsPackage", DiagnosticsPackageArgs.builder()
 *             .diagnosticsPackageName("dp1")
 *             .packetCoreControlPlaneName("TestPacketCoreCP")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:DiagnosticsPackage dp1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/diagnosticsPackages/{diagnosticsPackageName}
 * ```
 * @property diagnosticsPackageName The name of the diagnostics package.
 * @property packetCoreControlPlaneName The name of the packet core control plane.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class DiagnosticsPackageArgs(
    public val diagnosticsPackageName: Output<String>? = null,
    public val packetCoreControlPlaneName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.DiagnosticsPackageArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.DiagnosticsPackageArgs =
        com.pulumi.azurenative.mobilenetwork.DiagnosticsPackageArgs.builder()
            .diagnosticsPackageName(diagnosticsPackageName?.applyValue({ args0 -> args0 }))
            .packetCoreControlPlaneName(packetCoreControlPlaneName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiagnosticsPackageArgs].
 */
@PulumiTagMarker
public class DiagnosticsPackageArgsBuilder internal constructor() {
    private var diagnosticsPackageName: Output<String>? = null

    private var packetCoreControlPlaneName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the diagnostics package.
     */
    @JvmName("hbsyjxbveaqavcwo")
    public suspend fun diagnosticsPackageName(`value`: Output<String>) {
        this.diagnosticsPackageName = value
    }

    /**
     * @param value The name of the packet core control plane.
     */
    @JvmName("mvegdsddmfmoyeuh")
    public suspend fun packetCoreControlPlaneName(`value`: Output<String>) {
        this.packetCoreControlPlaneName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("peckfbuwysujtkoe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the diagnostics package.
     */
    @JvmName("jqqoqdwumkvnuwfq")
    public suspend fun diagnosticsPackageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnosticsPackageName = mapped
    }

    /**
     * @param value The name of the packet core control plane.
     */
    @JvmName("vgxnaphocogygxwt")
    public suspend fun packetCoreControlPlaneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packetCoreControlPlaneName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gslvnxthyykocfdc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): DiagnosticsPackageArgs = DiagnosticsPackageArgs(
        diagnosticsPackageName = diagnosticsPackageName,
        packetCoreControlPlaneName = packetCoreControlPlaneName,
        resourceGroupName = resourceGroupName,
    )
}
