@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.MobilenetworkFunctions.getAttachedDataNetworkPlain
import com.pulumi.azurenative.mobilenetwork.MobilenetworkFunctions.getDataNetworkPlain
import com.pulumi.azurenative.mobilenetwork.MobilenetworkFunctions.getDiagnosticsPackagePlain
import com.pulumi.azurenative.mobilenetwork.MobilenetworkFunctions.getMobileNetworkPlain
import com.pulumi.azurenative.mobilenetwork.MobilenetworkFunctions.getPacketCapturePlain
import com.pulumi.azurenative.mobilenetwork.MobilenetworkFunctions.getPacketCoreControlPlanePlain
import com.pulumi.azurenative.mobilenetwork.MobilenetworkFunctions.getPacketCoreDataPlanePlain
import com.pulumi.azurenative.mobilenetwork.MobilenetworkFunctions.getServicePlain
import com.pulumi.azurenative.mobilenetwork.MobilenetworkFunctions.getSimGroupPlain
import com.pulumi.azurenative.mobilenetwork.MobilenetworkFunctions.getSimPlain
import com.pulumi.azurenative.mobilenetwork.MobilenetworkFunctions.getSimPolicyPlain
import com.pulumi.azurenative.mobilenetwork.MobilenetworkFunctions.getSitePlain
import com.pulumi.azurenative.mobilenetwork.MobilenetworkFunctions.getSlicePlain
import com.pulumi.azurenative.mobilenetwork.MobilenetworkFunctions.listMobileNetworkSimGroupsPlain
import com.pulumi.azurenative.mobilenetwork.MobilenetworkFunctions.listMobileNetworkSimIdsPlain
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetAttachedDataNetworkPlainArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetAttachedDataNetworkPlainArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetDataNetworkPlainArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetDataNetworkPlainArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetDiagnosticsPackagePlainArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetDiagnosticsPackagePlainArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetMobileNetworkPlainArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetMobileNetworkPlainArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetPacketCapturePlainArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetPacketCapturePlainArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetPacketCoreControlPlanePlainArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetPacketCoreControlPlanePlainArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetPacketCoreDataPlanePlainArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetPacketCoreDataPlanePlainArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetServicePlainArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetSimGroupPlainArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetSimGroupPlainArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetSimPlainArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetSimPlainArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetSimPolicyPlainArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetSimPolicyPlainArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetSitePlainArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetSitePlainArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetSlicePlainArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.GetSlicePlainArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.ListMobileNetworkSimGroupsPlainArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.ListMobileNetworkSimGroupsPlainArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.ListMobileNetworkSimIdsPlainArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.ListMobileNetworkSimIdsPlainArgsBuilder
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetAttachedDataNetworkResult
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetDataNetworkResult
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetDiagnosticsPackageResult
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetMobileNetworkResult
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetPacketCaptureResult
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetPacketCoreControlPlaneResult
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetPacketCoreDataPlaneResult
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetServiceResult
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetSimGroupResult
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetSimPolicyResult
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetSimResult
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetSiteResult
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetSliceResult
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.ListMobileNetworkSimGroupsResult
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.ListMobileNetworkSimIdsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetAttachedDataNetworkResult.Companion.toKotlin as getAttachedDataNetworkResultToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetDataNetworkResult.Companion.toKotlin as getDataNetworkResultToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetDiagnosticsPackageResult.Companion.toKotlin as getDiagnosticsPackageResultToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetMobileNetworkResult.Companion.toKotlin as getMobileNetworkResultToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetPacketCaptureResult.Companion.toKotlin as getPacketCaptureResultToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetPacketCoreControlPlaneResult.Companion.toKotlin as getPacketCoreControlPlaneResultToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetPacketCoreDataPlaneResult.Companion.toKotlin as getPacketCoreDataPlaneResultToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetSimGroupResult.Companion.toKotlin as getSimGroupResultToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetSimPolicyResult.Companion.toKotlin as getSimPolicyResultToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetSimResult.Companion.toKotlin as getSimResultToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetSiteResult.Companion.toKotlin as getSiteResultToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.GetSliceResult.Companion.toKotlin as getSliceResultToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.ListMobileNetworkSimGroupsResult.Companion.toKotlin as listMobileNetworkSimGroupsResultToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.ListMobileNetworkSimIdsResult.Companion.toKotlin as listMobileNetworkSimIdsResultToKotlin

public object MobilenetworkFunctions {
    /**
     * Gets information about the specified attached data network.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01, 2024-04-01.
     * @param argument null
     * @return Attached data network resource. Must be created in the same location as its parent packet core data plane.
     */
    public suspend fun getAttachedDataNetwork(argument: GetAttachedDataNetworkPlainArgs): GetAttachedDataNetworkResult =
        getAttachedDataNetworkResultToKotlin(getAttachedDataNetworkPlain(argument.toJava()).await())

    /**
     * @see [getAttachedDataNetwork].
     * @param attachedDataNetworkName The name of the attached data network.
     * @param packetCoreControlPlaneName The name of the packet core control plane.
     * @param packetCoreDataPlaneName The name of the packet core data plane.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Attached data network resource. Must be created in the same location as its parent packet core data plane.
     */
    public suspend fun getAttachedDataNetwork(
        attachedDataNetworkName: String,
        packetCoreControlPlaneName: String,
        packetCoreDataPlaneName: String,
        resourceGroupName: String,
    ): GetAttachedDataNetworkResult {
        val argument = GetAttachedDataNetworkPlainArgs(
            attachedDataNetworkName = attachedDataNetworkName,
            packetCoreControlPlaneName = packetCoreControlPlaneName,
            packetCoreDataPlaneName = packetCoreDataPlaneName,
            resourceGroupName = resourceGroupName,
        )
        return getAttachedDataNetworkResultToKotlin(getAttachedDataNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getAttachedDataNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilenetwork&#46;kotlin&#46;inputs&#46;GetAttachedDataNetworkPlainArgs].
     * @return Attached data network resource. Must be created in the same location as its parent packet core data plane.
     */
    public suspend fun getAttachedDataNetwork(argument: suspend GetAttachedDataNetworkPlainArgsBuilder.() -> Unit): GetAttachedDataNetworkResult {
        val builder = GetAttachedDataNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAttachedDataNetworkResultToKotlin(getAttachedDataNetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified data network.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01, 2024-04-01.
     * @param argument null
     * @return Data network resource. Must be created in the same location as its parent mobile network.
     */
    public suspend fun getDataNetwork(argument: GetDataNetworkPlainArgs): GetDataNetworkResult =
        getDataNetworkResultToKotlin(getDataNetworkPlain(argument.toJava()).await())

    /**
     * @see [getDataNetwork].
     * @param dataNetworkName The name of the data network.
     * @param mobileNetworkName The name of the mobile network.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Data network resource. Must be created in the same location as its parent mobile network.
     */
    public suspend fun getDataNetwork(
        dataNetworkName: String,
        mobileNetworkName: String,
        resourceGroupName: String,
    ): GetDataNetworkResult {
        val argument = GetDataNetworkPlainArgs(
            dataNetworkName = dataNetworkName,
            mobileNetworkName = mobileNetworkName,
            resourceGroupName = resourceGroupName,
        )
        return getDataNetworkResultToKotlin(getDataNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilenetwork&#46;kotlin&#46;inputs&#46;GetDataNetworkPlainArgs].
     * @return Data network resource. Must be created in the same location as its parent mobile network.
     */
    public suspend fun getDataNetwork(argument: suspend GetDataNetworkPlainArgsBuilder.() -> Unit): GetDataNetworkResult {
        val builder = GetDataNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataNetworkResultToKotlin(getDataNetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified diagnostics package.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2023-09-01, 2024-02-01, 2024-04-01.
     * @param argument null
     * @return Diagnostics package resource.
     */
    public suspend fun getDiagnosticsPackage(argument: GetDiagnosticsPackagePlainArgs): GetDiagnosticsPackageResult =
        getDiagnosticsPackageResultToKotlin(getDiagnosticsPackagePlain(argument.toJava()).await())

    /**
     * @see [getDiagnosticsPackage].
     * @param diagnosticsPackageName The name of the diagnostics package.
     * @param packetCoreControlPlaneName The name of the packet core control plane.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Diagnostics package resource.
     */
    public suspend fun getDiagnosticsPackage(
        diagnosticsPackageName: String,
        packetCoreControlPlaneName: String,
        resourceGroupName: String,
    ): GetDiagnosticsPackageResult {
        val argument = GetDiagnosticsPackagePlainArgs(
            diagnosticsPackageName = diagnosticsPackageName,
            packetCoreControlPlaneName = packetCoreControlPlaneName,
            resourceGroupName = resourceGroupName,
        )
        return getDiagnosticsPackageResultToKotlin(getDiagnosticsPackagePlain(argument.toJava()).await())
    }

    /**
     * @see [getDiagnosticsPackage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilenetwork&#46;kotlin&#46;inputs&#46;GetDiagnosticsPackagePlainArgs].
     * @return Diagnostics package resource.
     */
    public suspend fun getDiagnosticsPackage(argument: suspend GetDiagnosticsPackagePlainArgsBuilder.() -> Unit): GetDiagnosticsPackageResult {
        val builder = GetDiagnosticsPackagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDiagnosticsPackageResultToKotlin(getDiagnosticsPackagePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified mobile network.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01, 2024-04-01.
     * @param argument null
     * @return Mobile network resource.
     */
    public suspend fun getMobileNetwork(argument: GetMobileNetworkPlainArgs): GetMobileNetworkResult =
        getMobileNetworkResultToKotlin(getMobileNetworkPlain(argument.toJava()).await())

    /**
     * @see [getMobileNetwork].
     * @param mobileNetworkName The name of the mobile network.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Mobile network resource.
     */
    public suspend fun getMobileNetwork(mobileNetworkName: String, resourceGroupName: String): GetMobileNetworkResult {
        val argument = GetMobileNetworkPlainArgs(
            mobileNetworkName = mobileNetworkName,
            resourceGroupName = resourceGroupName,
        )
        return getMobileNetworkResultToKotlin(getMobileNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getMobileNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilenetwork&#46;kotlin&#46;inputs&#46;GetMobileNetworkPlainArgs].
     * @return Mobile network resource.
     */
    public suspend fun getMobileNetwork(argument: suspend GetMobileNetworkPlainArgsBuilder.() -> Unit): GetMobileNetworkResult {
        val builder = GetMobileNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMobileNetworkResultToKotlin(getMobileNetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified packet capture session.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2023-09-01, 2024-02-01, 2024-04-01.
     * @param argument null
     * @return Packet capture session resource.
     */
    public suspend fun getPacketCapture(argument: GetPacketCapturePlainArgs): GetPacketCaptureResult =
        getPacketCaptureResultToKotlin(getPacketCapturePlain(argument.toJava()).await())

    /**
     * @see [getPacketCapture].
     * @param packetCaptureName The name of the packet capture session.
     * @param packetCoreControlPlaneName The name of the packet core control plane.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Packet capture session resource.
     */
    public suspend fun getPacketCapture(
        packetCaptureName: String,
        packetCoreControlPlaneName: String,
        resourceGroupName: String,
    ): GetPacketCaptureResult {
        val argument = GetPacketCapturePlainArgs(
            packetCaptureName = packetCaptureName,
            packetCoreControlPlaneName = packetCoreControlPlaneName,
            resourceGroupName = resourceGroupName,
        )
        return getPacketCaptureResultToKotlin(getPacketCapturePlain(argument.toJava()).await())
    }

    /**
     * @see [getPacketCapture].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilenetwork&#46;kotlin&#46;inputs&#46;GetPacketCapturePlainArgs].
     * @return Packet capture session resource.
     */
    public suspend fun getPacketCapture(argument: suspend GetPacketCapturePlainArgsBuilder.() -> Unit): GetPacketCaptureResult {
        val builder = GetPacketCapturePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPacketCaptureResultToKotlin(getPacketCapturePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified packet core control plane.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2022-03-01-preview, 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01, 2024-04-01.
     * @param argument null
     * @return Packet core control plane resource.
     */
    public suspend fun getPacketCoreControlPlane(argument: GetPacketCoreControlPlanePlainArgs): GetPacketCoreControlPlaneResult =
        getPacketCoreControlPlaneResultToKotlin(getPacketCoreControlPlanePlain(argument.toJava()).await())

    /**
     * @see [getPacketCoreControlPlane].
     * @param packetCoreControlPlaneName The name of the packet core control plane.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Packet core control plane resource.
     */
    public suspend fun getPacketCoreControlPlane(
        packetCoreControlPlaneName: String,
        resourceGroupName: String,
    ): GetPacketCoreControlPlaneResult {
        val argument = GetPacketCoreControlPlanePlainArgs(
            packetCoreControlPlaneName = packetCoreControlPlaneName,
            resourceGroupName = resourceGroupName,
        )
        return getPacketCoreControlPlaneResultToKotlin(getPacketCoreControlPlanePlain(argument.toJava()).await())
    }

    /**
     * @see [getPacketCoreControlPlane].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilenetwork&#46;kotlin&#46;inputs&#46;GetPacketCoreControlPlanePlainArgs].
     * @return Packet core control plane resource.
     */
    public suspend fun getPacketCoreControlPlane(argument: suspend GetPacketCoreControlPlanePlainArgsBuilder.() -> Unit): GetPacketCoreControlPlaneResult {
        val builder = GetPacketCoreControlPlanePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPacketCoreControlPlaneResultToKotlin(getPacketCoreControlPlanePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified packet core data plane.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01, 2024-04-01.
     * @param argument null
     * @return Packet core data plane resource. Must be created in the same location as its parent packet core control plane.
     */
    public suspend fun getPacketCoreDataPlane(argument: GetPacketCoreDataPlanePlainArgs): GetPacketCoreDataPlaneResult =
        getPacketCoreDataPlaneResultToKotlin(getPacketCoreDataPlanePlain(argument.toJava()).await())

    /**
     * @see [getPacketCoreDataPlane].
     * @param packetCoreControlPlaneName The name of the packet core control plane.
     * @param packetCoreDataPlaneName The name of the packet core data plane.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Packet core data plane resource. Must be created in the same location as its parent packet core control plane.
     */
    public suspend fun getPacketCoreDataPlane(
        packetCoreControlPlaneName: String,
        packetCoreDataPlaneName: String,
        resourceGroupName: String,
    ): GetPacketCoreDataPlaneResult {
        val argument = GetPacketCoreDataPlanePlainArgs(
            packetCoreControlPlaneName = packetCoreControlPlaneName,
            packetCoreDataPlaneName = packetCoreDataPlaneName,
            resourceGroupName = resourceGroupName,
        )
        return getPacketCoreDataPlaneResultToKotlin(getPacketCoreDataPlanePlain(argument.toJava()).await())
    }

    /**
     * @see [getPacketCoreDataPlane].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilenetwork&#46;kotlin&#46;inputs&#46;GetPacketCoreDataPlanePlainArgs].
     * @return Packet core data plane resource. Must be created in the same location as its parent packet core control plane.
     */
    public suspend fun getPacketCoreDataPlane(argument: suspend GetPacketCoreDataPlanePlainArgsBuilder.() -> Unit): GetPacketCoreDataPlaneResult {
        val builder = GetPacketCoreDataPlanePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPacketCoreDataPlaneResultToKotlin(getPacketCoreDataPlanePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified service.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01, 2024-04-01.
     * @param argument null
     * @return Service resource. Must be created in the same location as its parent mobile network.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param mobileNetworkName The name of the mobile network.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the service. You must not use any of the following reserved strings - `default`, `requested` or `service`
     * @return Service resource. Must be created in the same location as its parent mobile network.
     */
    public suspend fun getService(
        mobileNetworkName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetServiceResult {
        val argument = GetServicePlainArgs(
            mobileNetworkName = mobileNetworkName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilenetwork&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return Service resource. Must be created in the same location as its parent mobile network.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified SIM.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2022-03-01-preview, 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01, 2024-04-01.
     * @param argument null
     * @return SIM resource.
     */
    public suspend fun getSim(argument: GetSimPlainArgs): GetSimResult =
        getSimResultToKotlin(getSimPlain(argument.toJava()).await())

    /**
     * @see [getSim].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param simGroupName The name of the SIM Group.
     * @param simName The name of the SIM.
     * @return SIM resource.
     */
    public suspend fun getSim(
        resourceGroupName: String,
        simGroupName: String,
        simName: String,
    ): GetSimResult {
        val argument = GetSimPlainArgs(
            resourceGroupName = resourceGroupName,
            simGroupName = simGroupName,
            simName = simName,
        )
        return getSimResultToKotlin(getSimPlain(argument.toJava()).await())
    }

    /**
     * @see [getSim].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilenetwork&#46;kotlin&#46;inputs&#46;GetSimPlainArgs].
     * @return SIM resource.
     */
    public suspend fun getSim(argument: suspend GetSimPlainArgsBuilder.() -> Unit): GetSimResult {
        val builder = GetSimPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSimResultToKotlin(getSimPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified SIM group.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01, 2024-04-01.
     * @param argument null
     * @return SIM group resource.
     */
    public suspend fun getSimGroup(argument: GetSimGroupPlainArgs): GetSimGroupResult =
        getSimGroupResultToKotlin(getSimGroupPlain(argument.toJava()).await())

    /**
     * @see [getSimGroup].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param simGroupName The name of the SIM Group.
     * @return SIM group resource.
     */
    public suspend fun getSimGroup(resourceGroupName: String, simGroupName: String): GetSimGroupResult {
        val argument = GetSimGroupPlainArgs(
            resourceGroupName = resourceGroupName,
            simGroupName = simGroupName,
        )
        return getSimGroupResultToKotlin(getSimGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getSimGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilenetwork&#46;kotlin&#46;inputs&#46;GetSimGroupPlainArgs].
     * @return SIM group resource.
     */
    public suspend fun getSimGroup(argument: suspend GetSimGroupPlainArgsBuilder.() -> Unit): GetSimGroupResult {
        val builder = GetSimGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSimGroupResultToKotlin(getSimGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified SIM policy.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01, 2024-04-01.
     * @param argument null
     * @return SIM policy resource.
     */
    public suspend fun getSimPolicy(argument: GetSimPolicyPlainArgs): GetSimPolicyResult =
        getSimPolicyResultToKotlin(getSimPolicyPlain(argument.toJava()).await())

    /**
     * @see [getSimPolicy].
     * @param mobileNetworkName The name of the mobile network.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param simPolicyName The name of the SIM policy.
     * @return SIM policy resource.
     */
    public suspend fun getSimPolicy(
        mobileNetworkName: String,
        resourceGroupName: String,
        simPolicyName: String,
    ): GetSimPolicyResult {
        val argument = GetSimPolicyPlainArgs(
            mobileNetworkName = mobileNetworkName,
            resourceGroupName = resourceGroupName,
            simPolicyName = simPolicyName,
        )
        return getSimPolicyResultToKotlin(getSimPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getSimPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilenetwork&#46;kotlin&#46;inputs&#46;GetSimPolicyPlainArgs].
     * @return SIM policy resource.
     */
    public suspend fun getSimPolicy(argument: suspend GetSimPolicyPlainArgsBuilder.() -> Unit): GetSimPolicyResult {
        val builder = GetSimPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSimPolicyResultToKotlin(getSimPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified mobile network site.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01, 2024-04-01.
     * @param argument null
     * @return Site resource. Must be created in the same location as its parent mobile network.
     */
    public suspend fun getSite(argument: GetSitePlainArgs): GetSiteResult =
        getSiteResultToKotlin(getSitePlain(argument.toJava()).await())

    /**
     * @see [getSite].
     * @param mobileNetworkName The name of the mobile network.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param siteName The name of the mobile network site.
     * @return Site resource. Must be created in the same location as its parent mobile network.
     */
    public suspend fun getSite(
        mobileNetworkName: String,
        resourceGroupName: String,
        siteName: String,
    ): GetSiteResult {
        val argument = GetSitePlainArgs(
            mobileNetworkName = mobileNetworkName,
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
        return getSiteResultToKotlin(getSitePlain(argument.toJava()).await())
    }

    /**
     * @see [getSite].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilenetwork&#46;kotlin&#46;inputs&#46;GetSitePlainArgs].
     * @return Site resource. Must be created in the same location as its parent mobile network.
     */
    public suspend fun getSite(argument: suspend GetSitePlainArgsBuilder.() -> Unit): GetSiteResult {
        val builder = GetSitePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSiteResultToKotlin(getSitePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified network slice.
     * Azure REST API version: 2023-06-01.
     * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01, 2024-04-01.
     * @param argument null
     * @return Network slice resource. Must be created in the same location as its parent mobile network.
     */
    public suspend fun getSlice(argument: GetSlicePlainArgs): GetSliceResult =
        getSliceResultToKotlin(getSlicePlain(argument.toJava()).await())

    /**
     * @see [getSlice].
     * @param mobileNetworkName The name of the mobile network.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sliceName The name of the network slice.
     * @return Network slice resource. Must be created in the same location as its parent mobile network.
     */
    public suspend fun getSlice(
        mobileNetworkName: String,
        resourceGroupName: String,
        sliceName: String,
    ): GetSliceResult {
        val argument = GetSlicePlainArgs(
            mobileNetworkName = mobileNetworkName,
            resourceGroupName = resourceGroupName,
            sliceName = sliceName,
        )
        return getSliceResultToKotlin(getSlicePlain(argument.toJava()).await())
    }

    /**
     * @see [getSlice].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilenetwork&#46;kotlin&#46;inputs&#46;GetSlicePlainArgs].
     * @return Network slice resource. Must be created in the same location as its parent mobile network.
     */
    public suspend fun getSlice(argument: suspend GetSlicePlainArgsBuilder.() -> Unit): GetSliceResult {
        val builder = GetSlicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSliceResultToKotlin(getSlicePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets all the SIM groups assigned to a mobile network.
     * Azure REST API version: 2024-04-01.
     * @param argument null
     * @return Response for list SIM groups API service call.
     */
    public suspend fun listMobileNetworkSimGroups(argument: ListMobileNetworkSimGroupsPlainArgs): ListMobileNetworkSimGroupsResult =
        listMobileNetworkSimGroupsResultToKotlin(listMobileNetworkSimGroupsPlain(argument.toJava()).await())

    /**
     * @see [listMobileNetworkSimGroups].
     * @param mobileNetworkName The name of the mobile network.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response for list SIM groups API service call.
     */
    public suspend fun listMobileNetworkSimGroups(
        mobileNetworkName: String,
        resourceGroupName: String,
    ): ListMobileNetworkSimGroupsResult {
        val argument = ListMobileNetworkSimGroupsPlainArgs(
            mobileNetworkName = mobileNetworkName,
            resourceGroupName = resourceGroupName,
        )
        return listMobileNetworkSimGroupsResultToKotlin(listMobileNetworkSimGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [listMobileNetworkSimGroups].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilenetwork&#46;kotlin&#46;inputs&#46;ListMobileNetworkSimGroupsPlainArgs].
     * @return Response for list SIM groups API service call.
     */
    public suspend fun listMobileNetworkSimGroups(argument: suspend ListMobileNetworkSimGroupsPlainArgsBuilder.() -> Unit): ListMobileNetworkSimGroupsResult {
        val builder = ListMobileNetworkSimGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listMobileNetworkSimGroupsResultToKotlin(listMobileNetworkSimGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the IDs of all provisioned SIMs in a mobile network
     * Azure REST API version: 2022-04-01-preview.
     * @param argument null
     * @return Response for list SIM IDs API service call.
     */
    public suspend fun listMobileNetworkSimIds(argument: ListMobileNetworkSimIdsPlainArgs): ListMobileNetworkSimIdsResult =
        listMobileNetworkSimIdsResultToKotlin(listMobileNetworkSimIdsPlain(argument.toJava()).await())

    /**
     * @see [listMobileNetworkSimIds].
     * @param mobileNetworkName The name of the mobile network.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response for list SIM IDs API service call.
     */
    public suspend fun listMobileNetworkSimIds(mobileNetworkName: String, resourceGroupName: String): ListMobileNetworkSimIdsResult {
        val argument = ListMobileNetworkSimIdsPlainArgs(
            mobileNetworkName = mobileNetworkName,
            resourceGroupName = resourceGroupName,
        )
        return listMobileNetworkSimIdsResultToKotlin(listMobileNetworkSimIdsPlain(argument.toJava()).await())
    }

    /**
     * @see [listMobileNetworkSimIds].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilenetwork&#46;kotlin&#46;inputs&#46;ListMobileNetworkSimIdsPlainArgs].
     * @return Response for list SIM IDs API service call.
     */
    public suspend fun listMobileNetworkSimIds(argument: suspend ListMobileNetworkSimIdsPlainArgsBuilder.() -> Unit): ListMobileNetworkSimIdsResult {
        val builder = ListMobileNetworkSimIdsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listMobileNetworkSimIdsResultToKotlin(listMobileNetworkSimIdsPlain(builtArgument.toJava()).await())
    }
}
