@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.KeyVaultKeyResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.MobileNetworkResourceIdResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.KeyVaultKeyResponse.Companion.toKotlin as keyVaultKeyResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.MobileNetworkResourceIdResponse.Companion.toKotlin as mobileNetworkResourceIdResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SimGroup].
 */
@PulumiTagMarker
public class SimGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SimGroupArgs = SimGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SimGroupArgsBuilder.() -> Unit) {
        val builder = SimGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SimGroup {
        val builtJavaResource = com.pulumi.azurenative.mobilenetwork.SimGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SimGroup(builtJavaResource)
    }
}

/**
 * SIM group resource.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01, 2024-04-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:SimGroup testSimGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/simGroups/{simGroupName}
 * ```
 */
public class SimGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilenetwork.SimGroup,
) : KotlinCustomResource(javaResource, SimGroupMapper) {
    /**
     * A key to encrypt the SIM data that belongs to this SIM group.
     */
    public val encryptionKey: Output<KeyVaultKeyResponse>?
        get() = javaResource.encryptionKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> keyVaultKeyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The identity used to retrieve the encryption key from Azure key vault.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Mobile network that this SIM group belongs to. The mobile network must be in the same location as the SIM group.
     */
    public val mobileNetwork: Output<MobileNetworkResourceIdResponse>?
        get() = javaResource.mobileNetwork().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> mobileNetworkResourceIdResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the SIM group resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SimGroupMapper : ResourceMapper<SimGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilenetwork.SimGroup::class == javaResource::class

    override fun map(javaResource: Resource): SimGroup = SimGroup(
        javaResource as
            com.pulumi.azurenative.mobilenetwork.SimGroup,
    )
}

/**
 * @see [SimGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SimGroup].
 */
public suspend fun simGroup(name: String, block: suspend SimGroupResourceBuilder.() -> Unit): SimGroup {
    val builder = SimGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SimGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun simGroup(name: String): SimGroup {
    val builder = SimGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
