@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SnssaiResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SnssaiResponse.Companion.toKotlin as snssaiResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Slice].
 */
@PulumiTagMarker
public class SliceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SliceArgs = SliceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SliceArgsBuilder.() -> Unit) {
        val builder = SliceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Slice {
        val builtJavaResource = com.pulumi.azurenative.mobilenetwork.Slice(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Slice(builtJavaResource)
    }
}

/**
 * Network slice resource. Must be created in the same location as its parent mobile network.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01, 2024-04-01.
 * ## Example Usage
 * ### Create network slice
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var slice = new AzureNative.MobileNetwork.Slice("slice", new()
 *     {
 *         Description = "myFavouriteSlice",
 *         Location = "eastus",
 *         MobileNetworkName = "testMobileNetwork",
 *         ResourceGroupName = "rg1",
 *         SliceName = "testSlice",
 *         Snssai = new AzureNative.MobileNetwork.Inputs.SnssaiArgs
 *         {
 *             Sd = "1abcde",
 *             Sst = 1,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewSlice(ctx, "slice", &mobilenetwork.SliceArgs{
 * 			Description:       pulumi.String("myFavouriteSlice"),
 * 			Location:          pulumi.String("eastus"),
 * 			MobileNetworkName: pulumi.String("testMobileNetwork"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SliceName:         pulumi.String("testSlice"),
 * 			Snssai: &mobilenetwork.SnssaiArgs{
 * 				Sd:  pulumi.String("1abcde"),
 * 				Sst: pulumi.Int(1),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.Slice;
 * import com.pulumi.azurenative.mobilenetwork.SliceArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.SnssaiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var slice = new Slice("slice", SliceArgs.builder()
 *             .description("myFavouriteSlice")
 *             .location("eastus")
 *             .mobileNetworkName("testMobileNetwork")
 *             .resourceGroupName("rg1")
 *             .sliceName("testSlice")
 *             .snssai(SnssaiArgs.builder()
 *                 .sd("1abcde")
 *                 .sst(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:Slice testSlice /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/mobileNetworks/{mobileNetworkName}/slices/{sliceName}
 * ```
 */
public class Slice internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilenetwork.Slice,
) : KotlinCustomResource(javaResource, SliceMapper) {
    /**
     * An optional description for this network slice.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the network slice resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
     */
    public val snssai: Output<SnssaiResponse>
        get() = javaResource.snssai().applyValue({ args0 ->
            args0.let({ args0 ->
                snssaiResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SliceMapper : ResourceMapper<Slice> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilenetwork.Slice::class == javaResource::class

    override fun map(javaResource: Resource): Slice = Slice(
        javaResource as
            com.pulumi.azurenative.mobilenetwork.Slice,
    )
}

/**
 * @see [Slice].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Slice].
 */
public suspend fun slice(name: String, block: suspend SliceResourceBuilder.() -> Unit): Slice {
    val builder = SliceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Slice].
 * @param name The _unique_ name of the resulting resource.
 */
public fun slice(name: String): Slice {
    val builder = SliceResourceBuilder()
    builder.name(name)
    return builder.build()
}
