@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * How to authenticate users who access local diagnostics APIs.
 */
public enum class AuthenticationType(
    public val javaValue: com.pulumi.azurenative.mobilenetwork.enums.AuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.enums.AuthenticationType> {
    /**
     * Use AAD SSO to authenticate the user (this requires internet access).
     */
    AAD(com.pulumi.azurenative.mobilenetwork.enums.AuthenticationType.AAD),

    /**
     * Use locally stored passwords to authenticate the user.
     */
    Password(com.pulumi.azurenative.mobilenetwork.enums.AuthenticationType.Password),
    ;

    override fun toJava(): com.pulumi.azurenative.mobilenetwork.enums.AuthenticationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.enums.AuthenticationType): AuthenticationType = AuthenticationType.values().first { it.javaValue == javaType }
    }
}
