@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The default PDU session type, which is used if the UE does not request a specific session type.
 */
public enum class PduSessionType(
    public val javaValue: com.pulumi.azurenative.mobilenetwork.enums.PduSessionType,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.enums.PduSessionType> {
    IPv4(com.pulumi.azurenative.mobilenetwork.enums.PduSessionType.IPv4),
    IPv6(com.pulumi.azurenative.mobilenetwork.enums.PduSessionType.IPv6),
    ;

    override fun toJava(): com.pulumi.azurenative.mobilenetwork.enums.PduSessionType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.enums.PduSessionType): PduSessionType = PduSessionType.values().first { it.javaValue == javaType }
    }
}
