@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Default QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 */
public enum class PreemptionCapability(
    public val javaValue: com.pulumi.azurenative.mobilenetwork.enums.PreemptionCapability,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.enums.PreemptionCapability> {
    /**
     * Cannot preempt
     */
    NotPreempt(com.pulumi.azurenative.mobilenetwork.enums.PreemptionCapability.NotPreempt),

    /**
     * May preempt
     */
    MayPreempt(com.pulumi.azurenative.mobilenetwork.enums.PreemptionCapability.MayPreempt),
    ;

    override fun toJava(): com.pulumi.azurenative.mobilenetwork.enums.PreemptionCapability = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.enums.PreemptionCapability): PreemptionCapability = PreemptionCapability.values().first { it.javaValue == javaType }
    }
}
