@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Default QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 */
public enum class PreemptionVulnerability(
    public val javaValue: com.pulumi.azurenative.mobilenetwork.enums.PreemptionVulnerability,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.enums.PreemptionVulnerability> {
    /**
     * Cannot be preempted
     */
    NotPreemptable(com.pulumi.azurenative.mobilenetwork.enums.PreemptionVulnerability.NotPreemptable),

    /**
     * May be preempted
     */
    Preemptable(com.pulumi.azurenative.mobilenetwork.enums.PreemptionVulnerability.Preemptable),
    ;

    override fun toJava(): com.pulumi.azurenative.mobilenetwork.enums.PreemptionVulnerability =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.enums.PreemptionVulnerability): PreemptionVulnerability =
            PreemptionVulnerability.values().first { it.javaValue == javaType }
    }
}
