@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The direction of this flow.
 */
public enum class SdfDirection(
    public val javaValue: com.pulumi.azurenative.mobilenetwork.enums.SdfDirection,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.enums.SdfDirection> {
    /**
     * Traffic flowing from the UE to the data network.
     */
    Uplink(com.pulumi.azurenative.mobilenetwork.enums.SdfDirection.Uplink),

    /**
     * Traffic flowing from the data network to the UE.
     */
    Downlink(com.pulumi.azurenative.mobilenetwork.enums.SdfDirection.Downlink),

    /**
     * Traffic flowing both to and from the UE.
     */
    Bidirectional(com.pulumi.azurenative.mobilenetwork.enums.SdfDirection.Bidirectional),
    ;

    override fun toJava(): com.pulumi.azurenative.mobilenetwork.enums.SdfDirection = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.enums.SdfDirection): SdfDirection = SdfDirection.values().first { it.javaValue == javaType }
    }
}
