@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Determines whether flows that match this data flow policy rule are permitted.
 */
public enum class TrafficControlPermission(
    public val javaValue: com.pulumi.azurenative.mobilenetwork.enums.TrafficControlPermission,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.enums.TrafficControlPermission> {
    /**
     * Traffic matching this rule is allowed to flow.
     */
    Enabled(com.pulumi.azurenative.mobilenetwork.enums.TrafficControlPermission.Enabled),

    /**
     * Traffic matching this rule is not allowed to flow.
     */
    Blocked(com.pulumi.azurenative.mobilenetwork.enums.TrafficControlPermission.Blocked),
    ;

    override fun toJava(): com.pulumi.azurenative.mobilenetwork.enums.TrafficControlPermission =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.enums.TrafficControlPermission): TrafficControlPermission =
            TrafficControlPermission.values().first { it.javaValue == javaType }
    }
}
