@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.AttachedDataNetworkResourceIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to an attached data network resource.
 * @property id Attached data network resource ID.
 */
public data class AttachedDataNetworkResourceIdArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.AttachedDataNetworkResourceIdArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.AttachedDataNetworkResourceIdArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.AttachedDataNetworkResourceIdArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AttachedDataNetworkResourceIdArgs].
 */
@PulumiTagMarker
public class AttachedDataNetworkResourceIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Attached data network resource ID.
     */
    @JvmName("mxalfwnquwkrgces")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Attached data network resource ID.
     */
    @JvmName("mapqoravluvuvisq")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): AttachedDataNetworkResourceIdArgs = AttachedDataNetworkResourceIdArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
